/*
 * Globalize Culture no
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "no", "default", {
	name: "no",
	englishName: "Norwegian",
	nativeName: "norsk",
	language: "no",
	numberFormat: {
		",": " ",
		".": ",",
		negativeInfinity: "-INF",
		positiveInfinity: "INF",
		percent: {
			",": " ",
			".": ","
		},
		currency: {
			pattern: ["$ -n","$ n"],
			",": " ",
			".": ",",
			symbol: "kr"
		}
	},
	calendars: {
		standard: {
			"/": ".",
			firstDay: 1,
			days: {
				names: ["søndag","mandag","tirsdag","onsdag","torsdag","fredag","lørdag"],
				namesAbbr: ["sø","ma","ti","on","to","fr","lø"],
				namesShort: ["sø","ma","ti","on","to","fr","lø"]
			},
			months: {
				names: ["januar","februar","mars","april","mai","juni","juli","august","september","oktober","november","desember",""],
				namesAbbr: ["jan","feb","mar","apr","mai","jun","jul","aug","sep","okt","nov","des",""]
			},
			AM: null,
			PM: null,
			patterns: {
				d: "dd.MM.yyyy",
				D: "d. MMMM yyyy",
				t: "HH:mm",
				T: "HH:mm:ss",
				f: "d. MMMM yyyy HH:mm",
				F: "d. MMMM yyyy HH:mm:ss",
				M: "d. MMMM",
				Y: "MMMM yyyy"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "Bruker",
  "filetype_box user": "Bruker",
  "html": "HTML-fil",
  "filetype_html": "HTML-fil",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Nettside",
  "filetype_webscraperwebpage": "Nettside",
  "image": "Bilde",
  "filetype_image": "Bilde",
  "folder": "Mappe",
  "filetype_folder": "Mappe",
  "txt": "Tekst",
  "filetype_txt": "Tekst",
  "zip": "Zip-fil",
  "filetype_zip": "Zip-fil",
  "olefile": "OLE-fil",
  "filetype_olefile": "OLE-fil",
  "gmailmessage": "Gmail-melding",
  "filetype_gmailmessage": "Gmail-melding",
  "pdf": "PDF-fil",
  "filetype_pdf": "PDF-fil",
  "swf": "Flash-fil",
  "filetype_swf": "Flash-fil",
  "xml": "XML-fil",
  "filetype_xml": "XML-fil",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS-feed",
  "filetype_rssitem": "RSS-feed",
  "doc": "Dokument",
  "filetype_doc": "Dokument",
  "docx": "Microsoft Word-dokument",
  "filetype_docx": "Microsoft Word-dokument",
  "xls": "Regneark-dokument",
  "filetype_xls": "Regneark-dokument",
  "ppt": "Presentasjon-dokument",
  "filetype_ppt": "Presentasjon-dokument",
  "video": "Video",
  "filetype_video": "Video",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Text-dokument",
  "filetype_odt": "Open Text-dokument",
  "lithiummessage": "Lithium-melding",
  "filetype_lithiummessage": "Lithium-melding",
  "lithiumthread": "Lithium-tråd",
  "filetype_lithiumthread": "Lithium-tråd",
  "lithiumboard": "Lithium-tavle",
  "filetype_lithiumboard": "Lithium-tavle",
  "lithiumcategory": "Lithiium-kategori",
  "filetype_lithiumcategory": "Lithiium-kategori",
  "lithiumcommunity": "Lithium-samfunn",
  "filetype_lithiumcommunity": "Lithium-samfunn",
  "people": "Bruker",
  "objecttype_people": "Bruker",
  "message": "Melding",
  "objecttype_message": "Melding",
  "feed": "RSS-feed",
  "objecttype_feed": "RSS-feed",
  "thread": "Tråd",
  "objecttype_thread": "Tråd",
  "file": "Fil",
  "objecttype_file": "Fil",
  "board": "Tavle",
  "objecttype_board": "Tavle",
  "category": "Kategori",
  "objecttype_category": "Kategori",
  "account": "Konto",
  "objecttype_account": "Konto",
  "annotation": "Notat",
  "objecttype_annotation": "Notat",
  "campaign": "Kampanje",
  "objecttype_campaign": "Kampanje",
  "case": "Sak",
  "objecttype_case": "Sak",
  "contact": "Kontakt",
  "objecttype_contact": "Kontakt",
  "contract": "Kontrakt",
  "objecttype_contract": "Kontrakt",
  "event": "Hendelse",
  "objecttype_event": "Hendelse",
  "email": "E-post",
  "objecttype_email": "E-post",
  "goal": "Målsetting",
  "objecttype_goal": "Målsetting",
  "objecttype_incident": "Sak",
  "invoice": "Faktura",
  "objecttype_invoice": "Faktura",
  "lead": "Leder",
  "objecttype_lead": "Leder",
  "list": "Liste",
  "objecttype_list": "Markedsføringsliste",
  "solution": "Løsning",
  "objecttype_solution": "Løsning",
  "task": "Oppgave",
  "objecttype_task": "Oppgave",
  "user": "Bruker",
  "objecttype_user": "Bruker",
  "attachment": "Vedlegg",
  "objecttype_attachment": "Vedlegg",
  "casecomment": "Sakskommentar",
  "objecttype_casecomment": "Sakskommentar",
  "opportunity": "Mulighet",
  "objecttype_opportunity": "Mulighet",
  "opportunityproduct": "Opportunity-produkt",
  "objecttype_opportunityproduct": "Opportunity-produkt",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "Notat",
  "objecttype_note": "Notat",
  "product": "Produkt",
  "objecttype_product": "Produkt",
  "partner": "Partner",
  "objecttype_partner": "Partner",
  "queueitem": "Køelement",
  "objecttype_queueitem": "Køelement",
  "quote": "Sitat",
  "objecttype_quote": "Sitat",
  "salesliterature": "Salgslitteratur",
  "objecttype_salesliterature": "Salgslitteratur",
  "salesorder": "Salgsordre",
  "objecttype_salesorder": "Salgsordre",
  "service": "Service",
  "objecttype_service": "Service",
  "socialprofile": "Sosial profil",
  "objecttype_socialprofile": "Sosial profil",
  "kbdocumentation": "Dokumentasjon",
  "objecttype_kbdocumentation": "Dokumentasjon",
  "kbtechnicalarticle": "Dokumentasjon",
  "objecttype_kbtechnicalarticle": "Dokumentasjon",
  "kbsolution": "Løsning",
  "objecttype_kbsolution": "Løsning",
  "kbknowledgearticle": "Kunnskapsartikkel",
  "objecttype_kbknowledgearticle": "Kunnskapsartikkel",
  "kbattachment": "Vedlegg",
  "objecttype_kbattachment": "Vedlegg",
  "kbarticle": "Artikkel",
  "objecttype_kbarticle": "Artikkel",
  "kbarticlecomment": "Artikkelkommentar",
  "objecttype_kbarticlecomment": "Artikkelkommentar",
  "knowledgearticle": "Kunnskapsartikkel",
  "objecttype_knowledgearticle": "Kunnskapsartikkel",
  "topic": "Tema",
  "objecttype_topic": "Tema",
  "dashboard": "Dashbord",
  "objecttype_dashboard": "Dashbord",
  "contentversion": "Dokument",
  "objecttype_contentversion": "Dokument",
  "collaborationgroup": "Samarbeidsgruppe",
  "objecttype_collaborationgroup": "Samarbeidsgruppe",
  "spportal": "Portal",
  "filetype_spportal": "Portal",
  "spsite": "Side",
  "filetype_spsite": "Side",
  "spuserprofile": "SharePoint-bruker",
  "filetype_spuserprofile": "SharePoint-bruker",
  "sparea": "Område",
  "filetype_sparea": "Område",
  "spannouncement": "Kunngjøring",
  "filetype_spannouncement": "Kunngjøring",
  "spannouncementlist": "Kunngjøringer",
  "filetype_spannouncementlist": "Kunngjøringer",
  "spcontact": "Kontakt",
  "filetype_spcontact": "Kontakt",
  "spcontactlist": "Kontakter",
  "filetype_spcontactlist": "Kontakter",
  "spcustomlist": "Egendefinerte lister",
  "filetype_spcustomlist": "Egendefinerte lister",
  "spdiscussionboard": "Diskusjonspanel",
  "filetype_spdiscussionboard": "Diskusjonspanel",
  "spdiscussionboardlist": "Diskusjonspaneler",
  "filetype_spdiscussionboardlist": "Diskusjonspaneler",
  "spdocumentlibrarylist": "Dokumentbibliotek",
  "filetype_spdocumentlibrarylist": "Dokumentbibliotek",
  "spevent": "Hendelse",
  "filetype_spevent": "Hendelse",
  "speventlist": "Hendelser",
  "filetype_speventlist": "Hendelser",
  "spformlibrarylist": "Skjemabibliotek",
  "filetype_spformlibrarylist": "Skjemabibliotek",
  "spissue": "Emne",
  "filetype_spissue": "Emne",
  "spissuelist": "Emner",
  "filetype_spissuelist": "Emner",
  "splink": "Lenke",
  "filetype_splink": "Lenke",
  "splinklist": "Lenker",
  "filetype_splinklist": "Lenker",
  "sppicturelibrarylist": "Bildebibliotek",
  "filetype_sppicturelibrarylist": "Bildebibliotek",
  "spsurvey": "Undersøkelse",
  "filetype_spsurvey": "Undersøkelse",
  "spsurveylist": "Undersøkelser",
  "filetype_spsurveylist": "Undersøkelser",
  "sptask": "Oppgave",
  "filetype_sptask": "Oppgave",
  "sptasklist": "Oppgaver",
  "filetype_sptasklist": "Oppgaver",
  "spagenda": "Agenda",
  "filetype_spagenda": "Agenda",
  "spagendalist": "Agendaer",
  "filetype_spagendalist": "Agendaer",
  "spattendee": "Deltager",
  "filetype_spattendee": "Deltager",
  "spattendeelist": "Deltagere",
  "filetype_spattendeelist": "Deltagere",
  "spcustomgridlist": "Egendefinerte rutenett",
  "filetype_spcustomgridlist": "Egendefinerte rutenett",
  "spdecision": "Avgjørelse",
  "filetype_spdecision": "Avgjørelse",
  "spdecisionlist": "Avgjørelser",
  "filetype_spdecisionlist": "Avgjørelser",
  "spobjective": "Formål",
  "filetype_spobjective": "Formål",
  "spobjectivelist": "Formål",
  "filetype_spobjectivelist": "Formål",
  "sptextbox": "Tekstfelt",
  "filetype_sptextbox": "Tekstfelt",
  "sptextboxlist": "Tekstfelt-liste",
  "filetype_sptextboxlist": "Tekstfelt-liste",
  "spthingstobring": "Ting å ta med",
  "filetype_spthingstobring": "Ting å ta med",
  "spthingstobringlist": "Ting å ta med",
  "filetype_spthingstobringlist": "Ting å ta med",
  "sparealisting": "Områdeliste",
  "filetype_sparealisting": "Områdeliste",
  "spmeetingserie": "Møteserie",
  "filetype_spmeetingserie": "Møteserie",
  "spmeetingserielist": "Møteserie-liste",
  "filetype_spmeetingserielist": "Møteserie-liste",
  "spsitedirectory": "Sidekatalog-enhet",
  "filetype_spsitedirectory": "Sidekatalog-enhet",
  "spsitedirectorylist": "Sidekatalog",
  "filetype_spsitedirectorylist": "Sidekatalog",
  "spdatasource": "Datakilde",
  "filetype_spdatasource": "Datakilde",
  "spdatasourcelist": "Datakilde-liste",
  "filetype_spdatasourcelist": "Datakilde-liste",
  "splisttemplatecataloglist": "Liste over templatgalleri",
  "filetype_splisttemplatecataloglist": "Liste over templatgalleri",
  "spwebpartcataloglist": "WepPart-galleri",
  "filetype_spwebpartcataloglist": "WepPart-galleri",
  "spwebtemplatecataloglist": "Sidetemplat-galleri",
  "filetype_spwebtemplatecataloglist": "Sidetemplat-galleri",
  "spworkspacepagelist": "Workspace-sider",
  "filetype_spworkspacepagelist": "Workspace-sider",
  "spunknownlist": "Egendefinert liste",
  "filetype_spunknownlist": "Egendefinert liste",
  "spadministratortask": "Administratoroppgave",
  "filetype_spadministratortask": "Administratoroppgave",
  "spadministratortasklist": "Administratoroppgaver",
  "filetype_spadministratortasklist": "Administratoroppgaver",
  "spareadocumentlibrarylist": "Områdedokument-bibliotek",
  "filetype_spareadocumentlibrarylist": "Områdedokument-bibliotek",
  "spblogcategory": "Blogg-kategori",
  "filetype_spblogcategory": "Blogg-kategori",
  "spblogcategorylist": "Blogg-kategorier",
  "filetype_spblogcategorylist": "Blogg-kategorier",
  "spblogcomment": "Blogg-kommentar",
  "filetype_spblogcomment": "Blogg-kommentar",
  "spblogcommentlist": "Blogg-kommentarer",
  "filetype_spblogcommentlist": "Blogg-kommentarer",
  "spblogpost": "Blogg-post",
  "filetype_spblogpost": "Blogg-post",
  "spblogpostlist": "Blogg-poster",
  "filetype_spblogpostlist": "Blogg-poster",
  "spdataconnectionlibrarylist": "Dataforbindelse-bibliotek",
  "filetype_spdataconnectionlibrarylist": "Dataforbindelse-bibliotek",
  "spdistributiongroup": "Distribusjonsgruppe",
  "filetype_spdistributiongroup": "Distribusjonsgruppe",
  "spdistributiongrouplist": "Distribusjonsgrupper",
  "filetype_spdistributiongrouplist": "Distribusjonsgrupper",
  "spipfslist": "InfoPath Skjermaservere",
  "filetype_spipfslist": "InfoPath Skjermaservere",
  "spkeyperformanceindicator": "Nøkkelprestasjon-indikator",
  "filetype_spkeyperformanceindicator": "Nøkkelprestasjon-indikator",
  "spkeyperformanceindicatorlist": "Nøkkelprestasjon-indikatorer",
  "filetype_spkeyperformanceindicatorlist": "Nøkkelprestasjon-indikatorer",
  "splanguagesandtranslator": "Språk og oversetter",
  "filetype_splanguagesandtranslator": "Språk og oversetter",
  "splanguagesandtranslatorlist": "Språk og oversettere",
  "filetype_splanguagesandtranslatorlist": "Språk og oversettere",
  "spmasterpagescataloglist": "Hovedside-galleri",
  "filetype_spmasterpagescataloglist": "Hovedside-galleri",
  "spnocodeworkflowlibrarylist": "No-code Arbeidsflyt-biblioteker",
  "filetype_spnocodeworkflowlibrarylist": "No-code Arbeidsflyt-biblioteker",
  "spprojecttask": "Prosjektoppgave",
  "filetype_spprojecttask": "Prosjektoppgave",
  "spprojecttasklist": "Prosjektoppgaver",
  "filetype_spprojecttasklist": "Prosjektoppgaver",
  "sppublishingpageslibrarylist": "Sidebibliotek",
  "filetype_sppublishingpageslibrarylist": "Sidebibliotek",
  "spreportdocumentlibrarylist": "Rapportdokument-bibliotek",
  "filetype_spreportdocumentlibrarylist": "Rapportdokument-bibliotek",
  "spreportlibrarylist": "Rapport-bibliotek",
  "filetype_spreportlibrarylist": "Rapport-bibliotek",
  "spslidelibrarylist": "Sidebibliotek",
  "filetype_spslidelibrarylist": "Sidebibliotek",
  "sptab": "Faner",
  "filetype_sptab": "Faner",
  "sptablist": "Faneliste",
  "filetype_sptablist": "Faneliste",
  "sptranslationmanagementlibrarylist": "Oversettelseadministrasjon-bibliotek",
  "filetype_sptranslationmanagementlibrarylist": "Oversettelseadministrasjon-bibliotek",
  "spuserinformation": "Brukerinformasjon",
  "filetype_spuserinformation": "Brukerinformasjon",
  "spuserinformationlist": "Brukerinformasjon-liste",
  "filetype_spuserinformationlist": "Brukerinformasjon-liste",
  "spwikipagelibrarylist": "Wiki-side-bibliotek",
  "filetype_spwikipagelibrarylist": "Wiki-side-bibliotek",
  "spworkflowhistory": "Arbeidsflythistorikk",
  "filetype_spworkflowhistory": "Arbeidsflythistorikk",
  "spworkflowhistorylist": "Arbeidsflythistorikk-liste",
  "filetype_spworkflowhistorylist": "Arbeidsflythistorikk-liste",
  "spworkflowprocess": "Egendefinert arbeidsflyt-prosess",
  "filetype_spworkflowprocess": "Egendefinert arbeidsflyt-prosess",
  "spworkflowprocesslist": "Egendefinerte arbeidsflyt-prosesser",
  "filetype_spworkflowprocesslist": "Egendefinerte arbeidsflyt-prosesser",
  "sppublishingimageslibrarylist": "Publisering-bildebibliotek",
  "filetype_sppublishingimageslibrarylist": "Publisering-bildebibliotek",
  "spcirculation": "Sirkulering",
  "filetype_spcirculation": "Sirkulering",
  "spcirculationlist": "Sirkuleringer",
  "filetype_spcirculationlist": "Sirkuleringer",
  "spdashboardslibrarylist": "Bashbord-bibliotek",
  "filetype_spdashboardslibrarylist": "Bashbord-bibliotek",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint-dataforbindelse-bibliotek",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint-dataforbindelse-bibliotek",
  "sphealthreport": "Helserapport",
  "filetype_sphealthreport": "Helserapport",
  "sphealthreportlist": "Helserapporter",
  "filetype_sphealthreportlist": "Helserapporter",
  "sphealthrule": "Helseregel",
  "filetype_sphealthrule": "Helseregel",
  "sphealthrulelist": "Helseregler",
  "filetype_sphealthrulelist": "Helseregler",
  "spimedictionary": "IME-ordliste",
  "filetype_spimedictionary": "IME-ordliste",
  "spimedictionarylist": "IME-ordlister",
  "filetype_spimedictionarylist": "IME-ordlister",
  "spperformancepointcontent": "PerformancePoint-innhold",
  "filetype_spperformancepointcontent": "PerformancePoint-innhold",
  "spperformancepointcontentlist": "PerformancePoint-innhold",
  "filetype_spperformancepointcontentlist": "PerformancePoint-innhold",
  "spphonecallmemo": "Telefon-notat",
  "filetype_spphonecallmemo": "Telefon-notat",
  "spphonecallmemolist": "Telefon-notater",
  "filetype_spphonecallmemolist": "Telefon-notater",
  "sprecordlibrarylist": "Register-bibliotek",
  "filetype_sprecordlibrarylist": "Register-bibliotek",
  "spresource": "Ressurs",
  "filetype_spresource": "Ressurs",
  "spresourcelist": "Ressurser",
  "filetype_spresourcelist": "Ressurser",
  "spprocessdiagramslibrarylist": "Prosessdiagram-bibliotek",
  "filetype_spprocessdiagramslibrarylist": "Prosessdiagram-bibliotek",
  "spsitethemeslibrarylist": "Sidetema-bibliotek",
  "filetype_spsitethemeslibrarylist": "Sidetema-bibliotek",
  "spsolutionslibrarylist": "Løsningsbibliotek",
  "filetype_spsolutionslibrarylist": "Løsningsbibliotek",
  "spwfpublibrarylist": "WFPUB-bibliotek",
  "filetype_spwfpublibrarylist": "WFPUB-bibliotek",
  "spwhereabout": "Oppholdssted",
  "filetype_spwhereabout": "Oppholdssted",
  "spwhereaboutlist": "Oppholdssteder",
  "filetype_spwhereaboutlist": "Oppholdssteder",
  "spdocumentlink": "Lenke til et dokument",
  "filetype_spdocumentlink": "Lenke til et dokument",
  "spdocumentset": "Dokumentsett",
  "filetype_spdocumentset": "Dokumentsett",
  "spmicrofeedpost": "Mikrofeed-post",
  "filetype_spmicrofeedpost": "Mikrofeed-post",
  "spmicrofeedlist": "Mikrofeed",
  "filetype_spmicrofeedlist": "Mikrofeed",
  "splistfolder": "Listemappe",
  "filetype_splistfolder": "Listemappe",
  "Unknown": "Ukjent",
  "And": "OG",
  "Authenticating": "Autentiserer {0}…",
  "Clear": "Tøm {0}",
  "CompleteQuery": "Fullstendig forespørsel",
  "Exclude": "Ekskluder {0}",
  "EnterTag": "Legg til tag",
  "Next": "Neste",
  "Last": "Siste",
  "Link": "Link",
  "Or": "ELLER",
  "Previous": "Forrige",
  "QueryDidntMatchAnyDocuments": "Din forespørsel samsvarte ikke med noen dokumenter.",
  "QueryException": "Din forespørsel har en feil: {0}.",
  "Me": "Meg",
  "Remove": "Fjern",
  "Search": "Søk",
  "SearchFor": "Søk etter{0}",
  "ShareQuery": "Del forespørsel",
  "Preferences": "Preferanser",
  "LinkOpeningSettings": "Innstillinger for åpning av link",
  "Reauthenticate": "Autentiser på nytt {0}",
  "ResultsFilteringExpression": "Uttrykk for resultatfiltrering",
  "FiltersInYourPreferences": "Filtre i dine preferanser",
  "Create": "Opprett",
  "SearchIn": "Søk i {0}",
  "Seconds": "om {0} sekund<pl>er</pl>",
  "ShowingResultsOf": "Resultat<pl>er</pl>-{0}<pl>-{1}</pl> av {2}",
  "ShowingResultsOfWithQuery": "Resultat<pl>er</pl>-{0}<pl>-{1}</pl> av {2} for {3}",
  "SwitchTo": "Bytt til {0}",
  "Unexclude": "Ikke ekskluder {0}",
  "ClearAllFilters": "Tøm alle filtre",
  "SkipLogin": "Hopp over innlogging",
  "LoginInProgress": "Innlogging pågår, vennligst vent…",
  "Login": "Logg inn",
  "GetStarted": "Kom i gang",
  "More": "Mer",
  "NMore": "{0} mer...",
  "Less": "Mindre",
  "Settings": "Innstillinger",
  "Score": "Skår",
  "ScoreDescription": "Skåren er beregnet ut fra antall hendelser så vel som posisjonen i resultatsettet.",
  "Occurrences": "Hendelser",
  "OccurrencesDescription": "Sorter etter antall hendelser med verdier med høyest nummer først.",
  "Label": "Etikett",
  "Of": "av",
  "LabelDescription": "Sorter alfabetisk etter feltverdiene",
  "Value": "Verdi",
  "ValueDescription": "Sorter etter verdiene i det første beregnede feltet",
  "AlphaAscending": "Verdi stigende",
  "AlphaDescending": "Verdi synkende",
  "ChiSquare": "Chi-kvadrat",
  "Nosort": "Ingen sortering",
  "NosortDescription": "Ikke sorter verdiene. Verdiene vil komme tilbake i en tilfeldig rekkefølge.",
  "RelativeFrequency": "Relativ frekvens",
  "RelativeFrequencyDescription": "Sorter basert på den relative frekvensen av verdier. Mindre vanlige verdier vil vises høyere.",
  "DateDistribution": "Datodistribusjon",
  "Custom": "Tilpasset",
  "CustomDescription": "Sorter basert på en tilpasset rekkefølge",
  "ComputedField": "Beregnet felt",
  "Ascending": "Stigende",
  "Descending": "Synkende",
  "noResultFor": "Ingen resultater for {0}",
  "autoCorrectedQueryTo": "Forespørsel ble automatisk korrigert til {0}",
  "didYouMean": "Mente du: {0}",
  "SuggestedResults": "Foreslåtte resultater",
  "SuggestedQueries": "Foreslåtte forespørsler",
  "MostRelevantItems": "Mest relevante elementer:",
  "AllItems": "Alle elementer:",
  "ShowLess": "Vis mindre",
  "ShowMore": "Vis mer",
  "HideFacet": "Skjul fasett",
  "ShowFacet": "Vis fasett",
  "AndOthers": "og {0} <sn>annen</sn><pl>andre</pl>",
  "Others": "{0} <sn>annen</sn><pl>andre</pl>",
  "MostRelevantPosts": "Mest relevante poster",
  "CompleteThread": "Fullstendig tråd:",
  "ShowCompleteThread": "Vis fullstendig tråd",
  "ShowOnlyTopMatchingPosts": "Vis kun de postene som matcher best",
  "MostRelevantReplies": "Mest relevante svar",
  "AllConversation": "All konversasjon:",
  "ShowAllConversation": "Vis all konversasjon",
  "ShowAllReplies": "Vis alle svar",
  "ShowOnlyMostRelevantReplies": "Vis kun de mest relevante svarene",
  "Close": "Lukk",
  "Open": "Åpne",
  "OpenInOutlookWhenPossible": "Åpne i Outlook (hvor mulig)",
  "AlwaysOpenInNewWindow": "Åpne alltid resultater i nytt vindu",
  "Quickview": "Hurtigvisning",
  "NoQuickview": "Hurtigvisning for dette dokumentet er ikke tilgjengelig",
  "ErrorReport": "Feilrapport",
  "OopsError": "Noe gikk galt på serveren.",
  "ProblemPersists": "Kontakt administratoren hvis problemet vedvarer.",
  "GoBack": "Gå tilbake",
  "Reset": "Tilbakestill",
  "Retry": "Prøv på nytt",
  "MoreInfo": "Mer informasjon",
  "Username": "Brukernavn",
  "Password": "Passord",
  "PostedBy": "Postet av",
  "CannotConnect": "Kan ikke koble til serveradressen.",
  "BadUserPass": "Passord samsvarer ikke med brukernavnet.",
  "PleaseEnterYourCredentials": "Vennligst angi dine akkreditiver for {0}.",
  "PleaseEnterYourSearchPage": "Vennligst angi URL for din søkeside",
  "Collapse": "Fold sammen",
  "Collapsable": "Sammenfoldbar",
  "Expand": "Utvid",
  "Today": "I dag",
  "Yesterday": "I går",
  "Tomorrow": "I morgen",
  "Duration": "Varighet: {0}",
  "IndexDuration": "Indeks varighet: {0}",
  "ProxyDuration": "Proxy varighet: {0}",
  "ClientDuration": "Klient varighet: {0}",
  "Unavailable": "Utilgjengelig",
  "Reply": "Svar",
  "ReplyAll": "Svar alle",
  "Forward": "Videresend",
  "From": "Fra",
  "Caption": "Tittel",
  "Expression": "Uttrykk",
  "Tab": "Fane",
  "Tabs": "Faner",
  "EnterExpressionName": "Angi uttrykksnavn",
  "EnterExpressionToFilterWith": "Angi uttrykk å filtrere resultater med",
  "SelectTab": "Velg fane",
  "SelectAll": "Velg alle",
  "PageUrl": "Velg URL for side",
  "ErrorSavingToDevice": "Feil ved lagring av informasjon til din enhet",
  "ErrorReadingFromDevice": "Feil ved lesing av informasjon fra din enhet",
  "AppIntro": "Snakk med en produktspesialist som kan besvare dine spørsmål om Coveo og hjelpe deg å avgjøre hvilken Coveo-løsning som er riktig for deg. Eller prøv en live demo!",
  "TryDemo": "Prøv demoen",
  "ContactUs": "Kontakt oss",
  "NewToCoveo": "Ny med Coveo?",
  "LetUsHelpGetStarted": "La oss hjelpe deg å komme i gang",
  "LikesThis": "{0} liker dette.",
  "CannotConnectSearchPage": "kan ikke koble til din søkeside",
  "AreYouSureDeleteFilter": "Er du sikker på at du ønsker å slette filter {0} med uttrykket {1}",
  "OnlineHelp": "Online hjelp",
  "Done": "Ferdig",
  "SaveFacetState": "Lagre denne fasettstatusen",
  "ClearFacetState": "Tøm fasettstatus",
  "DisplayingTheOnlyMessage": "Viser den eneste meldingen i denne samtalen",
  "NoNetworkConnection": "Ingen nettverksforbindelse",
  "UnknownConnection": "Ukjent tilkobling",
  "EthernetConnection": "Ethernet-tilkobling",
  "WiFi": "WiFi-tilkobling",
  "CELL": "Mobil tilkobling",
  "CELL_2G": "Mobil 2G-tilkobling",
  "CELL_3G": "Mobil 3G-tilkobling",
  "CELL_4G": "Mobil 4G-tilkobling",
  "Relevance": "Relevans",
  "Date": "Dato",
  "Amount": "Mengde",
  "QueryExceptionNoException": "Ingen unntak",
  "QueryExceptionInvalidSyntax": "Ugyldig syntaks",
  "QueryExceptionInvalidCustomField": "Ugyldig tilpasset felt",
  "QueryExceptionInvalidDate": "Ugyldig dato",
  "QueryExceptionInvalidExactPhrase": "Ugyldig nøyaktig frase",
  "QueryExceptionInvalidDateOp": "Ugyldig datooperatør",
  "QueryExceptionInvalidNear": "Ugyldig NEAR-operatør",
  "QueryExceptionInvalidWeightedNear": "Ugyldig vektet NEAR",
  "QueryExceptionInvalidTerm": "Ugyldig term",
  "QueryExceptionTooManyTerms": "For mange termer",
  "QueryExceptionWildcardTooGeneral": "Jokertegn for generelt",
  "QueryExceptionInvalidSortField": "Ugyldig sorteringsfelt",
  "QueryExceptionInvalidSmallStringOp": "Ugyldig liten stringoperatør",
  "QueryExceptionRequestedResultsMax": "Forespurte resultater maksimum",
  "QueryExceptionAggregatedMirrorDead": "Fjern indekskopi offline",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Fjern indekskopi forespørsel timeout",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Fjern indekskopi ugyldig byggnummer",
  "QueryExceptionAggregatedMirrorCannotConnect": "Fjern indekskopi kan ikke koble til",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Ikke nok ledende tegn i jokertegn",
  "QueryExceptionSecurityInverterNotFound": "Sikkerhetsinverter ikke funnet",
  "QueryExceptionSecurityInverterAccessDenied": "Adgang til sikkerhetsinverter avslått",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Fjern indekskopi kan ikke representere",
  "QueryExceptionUnexpected": "Uventet",
  "QueryExceptionAccessDenied": "Adgang avslått",
  "QueryExceptionSuperUserTokenInvalid": "Superbruker symbol ikke gyldig",
  "QueryExceptionSuperUserTokenExpired": "Superbruker symbol er utløpt",
  "QueryExceptionLicenseQueriesExpired": "Forespørselslisens utløpt",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Lisens for superbruker symbol ikke støttet",
  "QueryExceptionInvalidSession": "Ugyldig økt",
  "QueryExceptionInvalidDocument": "Ugyldig dokument",
  "QueryExceptionSearchDisabled": "Søk deaktivert",
  "FileType": "Filtype",
  "ShowAttachment": "Vis vedlegg",
  "OnFeed": "på {0}s feed.",
  "Author": "Forfatter",
  "NoTitle": "Ingen tittel",
  "CurrentSelections": "Gjeldende valg",
  "AllContent": "Alt innhold",
  "CancelLastAction": "Avbryt siste handling",
  "SearchTips": "Søketips",
  "CheckSpelling": "Sjekk staving for dine nøkkelord",
  "TryUsingFewerKeywords": "Prøv å bruke færre, andre eller flere generelle nøkkelord.",
  "SelectFewerFilters": "Velg færre filtre for å utvide søket ditt",
  "Document": "Dokument",
  "Time": "Tid",
  "StartDate": "Startdato",
  "StartTime": "Starttid",
  "DurationTitle": "Varighet",
  "UserQuery": "Brukerforespørsel",
  "ShowUserActions": "Vis brukerhandlinger",
  "NoData": "Ingen data tilgjengelig",
  "EventType": "Hendelsetype",
  "GoToFullSearch": "Fult søk",
  "GoToEdition": "Tilpass panel",
  "RemoveContext": "Fjern kontekst",
  "BoxAttachToCase": "Legg ved sak",
  "AttachToCase": "Legg ved sak",
  "Attach": "Legg ved",
  "Attached": "Vedlagt",
  "Detach": "Løsne",
  "Details": "Detaljer",
  "AdditionalFilters": "Ytterligere filtre",
  "SelectNonContextualSearch": "Fjern kontekst fra den gjeldende registreringen for å utvide søket ditt",
  "CopyPasteToSupport": "Kopier og lim inn denne meldingen til Coveo Brukerstøtte for mer informasjon.",
  "FollowQueryDescription": "Send meg varsel om endringer i søkeresultatet for dette søket.",
  "SearchAlerts_Panel": "Administrer varsler",
  "SearchAlerts_PanelDescription": "Se og administrer dine søk-varsler.",
  "SearchAlerts_PanelNoSearchAlerts": "Du har ingen abonnementer.",
  "SearchAlerts_Fail": "Søk-varsel-tjenesten er for tiden ikke tilgjengelig.",
  "SearchAlerts_Type": "Type",
  "SearchAlerts_Content": "Innhold",
  "SearchAlerts_Actions": "Handling",
  "EmptyQuery": "<tom>",
  "SearchAlerts_Type_followQuery": "Forespørsel",
  "SearchAlerts_Type_followDocument": "Enhet",
  "SearchAlerts_unFollowing": "Slutt å følge",
  "SearchAlerts_follow": "Følg",
  "SearchAlerts_followed": "Fulgt",
  "SearchAlerts_followQuery": "Følg forespørsel",
  "Subscription_StopFollowingQuery": "Slutt å følge forespørsel",
  "SearchAlerts_Frequency": "Når",
  "SubscriptionsManageSubscriptions": "Administrer varsler",
  "SubscriptionsMessageFollowQuery": "Du vil motta varsler når forespørselen <b>{0}</b> kommer tilbake med nye eller oppdaterte enheter.",
  "SubscriptionsMessageFollow": "Du vil motta varsler om endringer for enheten <b>{0}</b>.",
  "Expiration": "Utløpsdato",
  "Monthly": "Månedlig",
  "Daily": "Daglig",
  "Monday": "Mandag",
  "Tuesday": "Tirsdag",
  "Wednesday": "Onsdag",
  "Thursday": "Torsdag",
  "Friday": "Fredag",
  "Saturday": "Lørdag",
  "Sunday": "Søndag",
  "NextDay": "Neste {0}",
  "LastDay": "Siste {0}",
  "StartTypingCaseForSuggestions": "Beskriv problemet ditt for å se mulige løsninger",
  "ExportToExcel": "Eksporter til Excel",
  "ExportToExcelDescription": "Eksporter søkeresultatene til Excel",
  "CaseCreationNoResults": "Ingen anbefalte løsninger ble funnet",
  "SortBy": "Sorter etter",
  "BoxCreateArticle": "Opprett artikkel",
  "Facets": "Fasetter",
  "AdvancedSearch": "Avansert søk",
  "Keywords": "Nøkkelord",
  "AllTheseWords": "Alle disse ordene",
  "ExactPhrase": "Denne eksakte frasen",
  "AnyOfTheseWords": "Ett av disse ordene",
  "NoneOfTheseWords": "Ingen av disse ordene",
  "Anytime": "Når som helst",
  "InTheLast": "I det minste",
  "Days": "dager",
  "Months": "måneder",
  "Month": "Måned",
  "Year": "År",
  "Between": "Mellom",
  "Language": "Språk",
  "Size": "Størrelse",
  "AtLeast": "minimum",
  "AtMost": "maksimum",
  "Contains": "inneholder",
  "DoesNotContain": "inneholder ikke",
  "Matches": "stemmer med",
  "Bytes": "byte",
  "card": "Kort",
  "table": "Tabell",
  "ResultLinks": "Resultat-lenker",
  "EnableQuerySyntax": "Aktiver søk-syntaks",
  "On": "På",
  "Off": "Av",
  "Automatic": "Automatisk",
  "ResultsPerPage": "Resultater per side",
  "PreviousMonth": "Forrige måned",
  "NextMonth": "Neste måned",
  "Title": "Tittel",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["no"] = merge(locales["no"], dict);
  String["toLocaleString"].call(this, { "no": dict });
  String["locale"] = "no";
  String["defaultLocale"] = "en";
  Globalize.culture("no")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "Bruker",
  "filetype_box user": "Bruker",
  "html": "HTML-fil",
  "filetype_html": "HTML-fil",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Nettside",
  "filetype_webscraperwebpage": "Nettside",
  "image": "Bilde",
  "filetype_image": "Bilde",
  "folder": "Mappe",
  "filetype_folder": "Mappe",
  "txt": "Tekst",
  "filetype_txt": "Tekst",
  "zip": "Zip-fil",
  "filetype_zip": "Zip-fil",
  "olefile": "OLE-fil",
  "filetype_olefile": "OLE-fil",
  "gmailmessage": "Gmail-melding",
  "filetype_gmailmessage": "Gmail-melding",
  "pdf": "PDF-fil",
  "filetype_pdf": "PDF-fil",
  "swf": "Flash-fil",
  "filetype_swf": "Flash-fil",
  "xml": "XML-fil",
  "filetype_xml": "XML-fil",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS-feed",
  "filetype_rssitem": "RSS-feed",
  "doc": "Dokument",
  "filetype_doc": "Dokument",
  "docx": "Microsoft Word-dokument",
  "filetype_docx": "Microsoft Word-dokument",
  "xls": "Regneark-dokument",
  "filetype_xls": "Regneark-dokument",
  "ppt": "Presentasjon-dokument",
  "filetype_ppt": "Presentasjon-dokument",
  "video": "Video",
  "filetype_video": "Video",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Text-dokument",
  "filetype_odt": "Open Text-dokument",
  "lithiummessage": "Lithium-melding",
  "filetype_lithiummessage": "Lithium-melding",
  "lithiumthread": "Lithium-tråd",
  "filetype_lithiumthread": "Lithium-tråd",
  "lithiumboard": "Lithium-tavle",
  "filetype_lithiumboard": "Lithium-tavle",
  "lithiumcategory": "Lithiium-kategori",
  "filetype_lithiumcategory": "Lithiium-kategori",
  "lithiumcommunity": "Lithium-samfunn",
  "filetype_lithiumcommunity": "Lithium-samfunn",
  "people": "Bruker",
  "objecttype_people": "Bruker",
  "message": "Melding",
  "objecttype_message": "Melding",
  "feed": "RSS-feed",
  "objecttype_feed": "RSS-feed",
  "thread": "Tråd",
  "objecttype_thread": "Tråd",
  "file": "Fil",
  "objecttype_file": "Fil",
  "board": "Tavle",
  "objecttype_board": "Tavle",
  "category": "Kategori",
  "objecttype_category": "Kategori",
  "account": "Konto",
  "objecttype_account": "Konto",
  "annotation": "Notat",
  "objecttype_annotation": "Notat",
  "campaign": "Kampanje",
  "objecttype_campaign": "Kampanje",
  "case": "Sak",
  "objecttype_case": "Sak",
  "contact": "Kontakt",
  "objecttype_contact": "Kontakt",
  "contract": "Kontrakt",
  "objecttype_contract": "Kontrakt",
  "event": "Hendelse",
  "objecttype_event": "Hendelse",
  "email": "E-post",
  "objecttype_email": "E-post",
  "goal": "Målsetting",
  "objecttype_goal": "Målsetting",
  "objecttype_incident": "Sak",
  "invoice": "Faktura",
  "objecttype_invoice": "Faktura",
  "lead": "Leder",
  "objecttype_lead": "Leder",
  "list": "Liste",
  "objecttype_list": "Markedsføringsliste",
  "solution": "Løsning",
  "objecttype_solution": "Løsning",
  "task": "Oppgave",
  "objecttype_task": "Oppgave",
  "user": "Bruker",
  "objecttype_user": "Bruker",
  "attachment": "Vedlegg",
  "objecttype_attachment": "Vedlegg",
  "casecomment": "Sakskommentar",
  "objecttype_casecomment": "Sakskommentar",
  "opportunity": "Mulighet",
  "objecttype_opportunity": "Mulighet",
  "opportunityproduct": "Opportunity-produkt",
  "objecttype_opportunityproduct": "Opportunity-produkt",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "Notat",
  "objecttype_note": "Notat",
  "product": "Produkt",
  "objecttype_product": "Produkt",
  "partner": "Partner",
  "objecttype_partner": "Partner",
  "queueitem": "Køelement",
  "objecttype_queueitem": "Køelement",
  "quote": "Sitat",
  "objecttype_quote": "Sitat",
  "salesliterature": "Salgslitteratur",
  "objecttype_salesliterature": "Salgslitteratur",
  "salesorder": "Salgsordre",
  "objecttype_salesorder": "Salgsordre",
  "service": "Service",
  "objecttype_service": "Service",
  "socialprofile": "Sosial profil",
  "objecttype_socialprofile": "Sosial profil",
  "kbdocumentation": "Dokumentasjon",
  "objecttype_kbdocumentation": "Dokumentasjon",
  "kbtechnicalarticle": "Dokumentasjon",
  "objecttype_kbtechnicalarticle": "Dokumentasjon",
  "kbsolution": "Løsning",
  "objecttype_kbsolution": "Løsning",
  "kbknowledgearticle": "Kunnskapsartikkel",
  "objecttype_kbknowledgearticle": "Kunnskapsartikkel",
  "kbattachment": "Vedlegg",
  "objecttype_kbattachment": "Vedlegg",
  "kbarticle": "Artikkel",
  "objecttype_kbarticle": "Artikkel",
  "kbarticlecomment": "Artikkelkommentar",
  "objecttype_kbarticlecomment": "Artikkelkommentar",
  "knowledgearticle": "Kunnskapsartikkel",
  "objecttype_knowledgearticle": "Kunnskapsartikkel",
  "topic": "Tema",
  "objecttype_topic": "Tema",
  "dashboard": "Dashbord",
  "objecttype_dashboard": "Dashbord",
  "contentversion": "Dokument",
  "objecttype_contentversion": "Dokument",
  "collaborationgroup": "Samarbeidsgruppe",
  "objecttype_collaborationgroup": "Samarbeidsgruppe",
  "spportal": "Portal",
  "filetype_spportal": "Portal",
  "spsite": "Side",
  "filetype_spsite": "Side",
  "spuserprofile": "SharePoint-bruker",
  "filetype_spuserprofile": "SharePoint-bruker",
  "sparea": "Område",
  "filetype_sparea": "Område",
  "spannouncement": "Kunngjøring",
  "filetype_spannouncement": "Kunngjøring",
  "spannouncementlist": "Kunngjøringer",
  "filetype_spannouncementlist": "Kunngjøringer",
  "spcontact": "Kontakt",
  "filetype_spcontact": "Kontakt",
  "spcontactlist": "Kontakter",
  "filetype_spcontactlist": "Kontakter",
  "spcustomlist": "Egendefinerte lister",
  "filetype_spcustomlist": "Egendefinerte lister",
  "spdiscussionboard": "Diskusjonspanel",
  "filetype_spdiscussionboard": "Diskusjonspanel",
  "spdiscussionboardlist": "Diskusjonspaneler",
  "filetype_spdiscussionboardlist": "Diskusjonspaneler",
  "spdocumentlibrarylist": "Dokumentbibliotek",
  "filetype_spdocumentlibrarylist": "Dokumentbibliotek",
  "spevent": "Hendelse",
  "filetype_spevent": "Hendelse",
  "speventlist": "Hendelser",
  "filetype_speventlist": "Hendelser",
  "spformlibrarylist": "Skjemabibliotek",
  "filetype_spformlibrarylist": "Skjemabibliotek",
  "spissue": "Emne",
  "filetype_spissue": "Emne",
  "spissuelist": "Emner",
  "filetype_spissuelist": "Emner",
  "splink": "Lenke",
  "filetype_splink": "Lenke",
  "splinklist": "Lenker",
  "filetype_splinklist": "Lenker",
  "sppicturelibrarylist": "Bildebibliotek",
  "filetype_sppicturelibrarylist": "Bildebibliotek",
  "spsurvey": "Undersøkelse",
  "filetype_spsurvey": "Undersøkelse",
  "spsurveylist": "Undersøkelser",
  "filetype_spsurveylist": "Undersøkelser",
  "sptask": "Oppgave",
  "filetype_sptask": "Oppgave",
  "sptasklist": "Oppgaver",
  "filetype_sptasklist": "Oppgaver",
  "spagenda": "Agenda",
  "filetype_spagenda": "Agenda",
  "spagendalist": "Agendaer",
  "filetype_spagendalist": "Agendaer",
  "spattendee": "Deltager",
  "filetype_spattendee": "Deltager",
  "spattendeelist": "Deltagere",
  "filetype_spattendeelist": "Deltagere",
  "spcustomgridlist": "Egendefinerte rutenett",
  "filetype_spcustomgridlist": "Egendefinerte rutenett",
  "spdecision": "Avgjørelse",
  "filetype_spdecision": "Avgjørelse",
  "spdecisionlist": "Avgjørelser",
  "filetype_spdecisionlist": "Avgjørelser",
  "spobjective": "Formål",
  "filetype_spobjective": "Formål",
  "spobjectivelist": "Formål",
  "filetype_spobjectivelist": "Formål",
  "sptextbox": "Tekstfelt",
  "filetype_sptextbox": "Tekstfelt",
  "sptextboxlist": "Tekstfelt-liste",
  "filetype_sptextboxlist": "Tekstfelt-liste",
  "spthingstobring": "Ting å ta med",
  "filetype_spthingstobring": "Ting å ta med",
  "spthingstobringlist": "Ting å ta med",
  "filetype_spthingstobringlist": "Ting å ta med",
  "sparealisting": "Områdeliste",
  "filetype_sparealisting": "Områdeliste",
  "spmeetingserie": "Møteserie",
  "filetype_spmeetingserie": "Møteserie",
  "spmeetingserielist": "Møteserie-liste",
  "filetype_spmeetingserielist": "Møteserie-liste",
  "spsitedirectory": "Sidekatalog-enhet",
  "filetype_spsitedirectory": "Sidekatalog-enhet",
  "spsitedirectorylist": "Sidekatalog",
  "filetype_spsitedirectorylist": "Sidekatalog",
  "spdatasource": "Datakilde",
  "filetype_spdatasource": "Datakilde",
  "spdatasourcelist": "Datakilde-liste",
  "filetype_spdatasourcelist": "Datakilde-liste",
  "splisttemplatecataloglist": "Liste over templatgalleri",
  "filetype_splisttemplatecataloglist": "Liste over templatgalleri",
  "spwebpartcataloglist": "WepPart-galleri",
  "filetype_spwebpartcataloglist": "WepPart-galleri",
  "spwebtemplatecataloglist": "Sidetemplat-galleri",
  "filetype_spwebtemplatecataloglist": "Sidetemplat-galleri",
  "spworkspacepagelist": "Workspace-sider",
  "filetype_spworkspacepagelist": "Workspace-sider",
  "spunknownlist": "Egendefinert liste",
  "filetype_spunknownlist": "Egendefinert liste",
  "spadministratortask": "Administratoroppgave",
  "filetype_spadministratortask": "Administratoroppgave",
  "spadministratortasklist": "Administratoroppgaver",
  "filetype_spadministratortasklist": "Administratoroppgaver",
  "spareadocumentlibrarylist": "Områdedokument-bibliotek",
  "filetype_spareadocumentlibrarylist": "Områdedokument-bibliotek",
  "spblogcategory": "Blogg-kategori",
  "filetype_spblogcategory": "Blogg-kategori",
  "spblogcategorylist": "Blogg-kategorier",
  "filetype_spblogcategorylist": "Blogg-kategorier",
  "spblogcomment": "Blogg-kommentar",
  "filetype_spblogcomment": "Blogg-kommentar",
  "spblogcommentlist": "Blogg-kommentarer",
  "filetype_spblogcommentlist": "Blogg-kommentarer",
  "spblogpost": "Blogg-post",
  "filetype_spblogpost": "Blogg-post",
  "spblogpostlist": "Blogg-poster",
  "filetype_spblogpostlist": "Blogg-poster",
  "spdataconnectionlibrarylist": "Dataforbindelse-bibliotek",
  "filetype_spdataconnectionlibrarylist": "Dataforbindelse-bibliotek",
  "spdistributiongroup": "Distribusjonsgruppe",
  "filetype_spdistributiongroup": "Distribusjonsgruppe",
  "spdistributiongrouplist": "Distribusjonsgrupper",
  "filetype_spdistributiongrouplist": "Distribusjonsgrupper",
  "spipfslist": "InfoPath Skjermaservere",
  "filetype_spipfslist": "InfoPath Skjermaservere",
  "spkeyperformanceindicator": "Nøkkelprestasjon-indikator",
  "filetype_spkeyperformanceindicator": "Nøkkelprestasjon-indikator",
  "spkeyperformanceindicatorlist": "Nøkkelprestasjon-indikatorer",
  "filetype_spkeyperformanceindicatorlist": "Nøkkelprestasjon-indikatorer",
  "splanguagesandtranslator": "Språk og oversetter",
  "filetype_splanguagesandtranslator": "Språk og oversetter",
  "splanguagesandtranslatorlist": "Språk og oversettere",
  "filetype_splanguagesandtranslatorlist": "Språk og oversettere",
  "spmasterpagescataloglist": "Hovedside-galleri",
  "filetype_spmasterpagescataloglist": "Hovedside-galleri",
  "spnocodeworkflowlibrarylist": "No-code Arbeidsflyt-biblioteker",
  "filetype_spnocodeworkflowlibrarylist": "No-code Arbeidsflyt-biblioteker",
  "spprojecttask": "Prosjektoppgave",
  "filetype_spprojecttask": "Prosjektoppgave",
  "spprojecttasklist": "Prosjektoppgaver",
  "filetype_spprojecttasklist": "Prosjektoppgaver",
  "sppublishingpageslibrarylist": "Sidebibliotek",
  "filetype_sppublishingpageslibrarylist": "Sidebibliotek",
  "spreportdocumentlibrarylist": "Rapportdokument-bibliotek",
  "filetype_spreportdocumentlibrarylist": "Rapportdokument-bibliotek",
  "spreportlibrarylist": "Rapport-bibliotek",
  "filetype_spreportlibrarylist": "Rapport-bibliotek",
  "spslidelibrarylist": "Sidebibliotek",
  "filetype_spslidelibrarylist": "Sidebibliotek",
  "sptab": "Faner",
  "filetype_sptab": "Faner",
  "sptablist": "Faneliste",
  "filetype_sptablist": "Faneliste",
  "sptranslationmanagementlibrarylist": "Oversettelseadministrasjon-bibliotek",
  "filetype_sptranslationmanagementlibrarylist": "Oversettelseadministrasjon-bibliotek",
  "spuserinformation": "Brukerinformasjon",
  "filetype_spuserinformation": "Brukerinformasjon",
  "spuserinformationlist": "Brukerinformasjon-liste",
  "filetype_spuserinformationlist": "Brukerinformasjon-liste",
  "spwikipagelibrarylist": "Wiki-side-bibliotek",
  "filetype_spwikipagelibrarylist": "Wiki-side-bibliotek",
  "spworkflowhistory": "Arbeidsflythistorikk",
  "filetype_spworkflowhistory": "Arbeidsflythistorikk",
  "spworkflowhistorylist": "Arbeidsflythistorikk-liste",
  "filetype_spworkflowhistorylist": "Arbeidsflythistorikk-liste",
  "spworkflowprocess": "Egendefinert arbeidsflyt-prosess",
  "filetype_spworkflowprocess": "Egendefinert arbeidsflyt-prosess",
  "spworkflowprocesslist": "Egendefinerte arbeidsflyt-prosesser",
  "filetype_spworkflowprocesslist": "Egendefinerte arbeidsflyt-prosesser",
  "sppublishingimageslibrarylist": "Publisering-bildebibliotek",
  "filetype_sppublishingimageslibrarylist": "Publisering-bildebibliotek",
  "spcirculation": "Sirkulering",
  "filetype_spcirculation": "Sirkulering",
  "spcirculationlist": "Sirkuleringer",
  "filetype_spcirculationlist": "Sirkuleringer",
  "spdashboardslibrarylist": "Bashbord-bibliotek",
  "filetype_spdashboardslibrarylist": "Bashbord-bibliotek",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint-dataforbindelse-bibliotek",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint-dataforbindelse-bibliotek",
  "sphealthreport": "Helserapport",
  "filetype_sphealthreport": "Helserapport",
  "sphealthreportlist": "Helserapporter",
  "filetype_sphealthreportlist": "Helserapporter",
  "sphealthrule": "Helseregel",
  "filetype_sphealthrule": "Helseregel",
  "sphealthrulelist": "Helseregler",
  "filetype_sphealthrulelist": "Helseregler",
  "spimedictionary": "IME-ordliste",
  "filetype_spimedictionary": "IME-ordliste",
  "spimedictionarylist": "IME-ordlister",
  "filetype_spimedictionarylist": "IME-ordlister",
  "spperformancepointcontent": "PerformancePoint-innhold",
  "filetype_spperformancepointcontent": "PerformancePoint-innhold",
  "spperformancepointcontentlist": "PerformancePoint-innhold",
  "filetype_spperformancepointcontentlist": "PerformancePoint-innhold",
  "spphonecallmemo": "Telefon-notat",
  "filetype_spphonecallmemo": "Telefon-notat",
  "spphonecallmemolist": "Telefon-notater",
  "filetype_spphonecallmemolist": "Telefon-notater",
  "sprecordlibrarylist": "Register-bibliotek",
  "filetype_sprecordlibrarylist": "Register-bibliotek",
  "spresource": "Ressurs",
  "filetype_spresource": "Ressurs",
  "spresourcelist": "Ressurser",
  "filetype_spresourcelist": "Ressurser",
  "spprocessdiagramslibrarylist": "Prosessdiagram-bibliotek",
  "filetype_spprocessdiagramslibrarylist": "Prosessdiagram-bibliotek",
  "spsitethemeslibrarylist": "Sidetema-bibliotek",
  "filetype_spsitethemeslibrarylist": "Sidetema-bibliotek",
  "spsolutionslibrarylist": "Løsningsbibliotek",
  "filetype_spsolutionslibrarylist": "Løsningsbibliotek",
  "spwfpublibrarylist": "WFPUB-bibliotek",
  "filetype_spwfpublibrarylist": "WFPUB-bibliotek",
  "spwhereabout": "Oppholdssted",
  "filetype_spwhereabout": "Oppholdssted",
  "spwhereaboutlist": "Oppholdssteder",
  "filetype_spwhereaboutlist": "Oppholdssteder",
  "spdocumentlink": "Lenke til et dokument",
  "filetype_spdocumentlink": "Lenke til et dokument",
  "spdocumentset": "Dokumentsett",
  "filetype_spdocumentset": "Dokumentsett",
  "spmicrofeedpost": "Mikrofeed-post",
  "filetype_spmicrofeedpost": "Mikrofeed-post",
  "spmicrofeedlist": "Mikrofeed",
  "filetype_spmicrofeedlist": "Mikrofeed",
  "splistfolder": "Listemappe",
  "filetype_splistfolder": "Listemappe",
  "Unknown": "Ukjent",
  "And": "OG",
  "Authenticating": "Autentiserer {0}…",
  "Clear": "Tøm {0}",
  "CompleteQuery": "Fullstendig forespørsel",
  "Exclude": "Ekskluder {0}",
  "EnterTag": "Legg til tag",
  "Next": "Neste",
  "Last": "Siste",
  "Link": "Link",
  "Or": "ELLER",
  "Previous": "Forrige",
  "QueryDidntMatchAnyDocuments": "Din forespørsel samsvarte ikke med noen dokumenter.",
  "QueryException": "Din forespørsel har en feil: {0}.",
  "Me": "Meg",
  "Remove": "Fjern",
  "Search": "Søk",
  "SearchFor": "Søk etter{0}",
  "ShareQuery": "Del forespørsel",
  "Preferences": "Preferanser",
  "LinkOpeningSettings": "Innstillinger for åpning av link",
  "Reauthenticate": "Autentiser på nytt {0}",
  "ResultsFilteringExpression": "Uttrykk for resultatfiltrering",
  "FiltersInYourPreferences": "Filtre i dine preferanser",
  "Create": "Opprett",
  "SearchIn": "Søk i {0}",
  "Seconds": "om {0} sekund<pl>er</pl>",
  "ShowingResultsOf": "Resultat<pl>er</pl>-{0}<pl>-{1}</pl> av {2}",
  "ShowingResultsOfWithQuery": "Resultat<pl>er</pl>-{0}<pl>-{1}</pl> av {2} for {3}",
  "SwitchTo": "Bytt til {0}",
  "Unexclude": "Ikke ekskluder {0}",
  "ClearAllFilters": "Tøm alle filtre",
  "SkipLogin": "Hopp over innlogging",
  "LoginInProgress": "Innlogging pågår, vennligst vent…",
  "Login": "Logg inn",
  "GetStarted": "Kom i gang",
  "More": "Mer",
  "NMore": "{0} mer...",
  "Less": "Mindre",
  "Settings": "Innstillinger",
  "Score": "Skår",
  "ScoreDescription": "Skåren er beregnet ut fra antall hendelser så vel som posisjonen i resultatsettet.",
  "Occurrences": "Hendelser",
  "OccurrencesDescription": "Sorter etter antall hendelser med verdier med høyest nummer først.",
  "Label": "Etikett",
  "Of": "av",
  "LabelDescription": "Sorter alfabetisk etter feltverdiene",
  "Value": "Verdi",
  "ValueDescription": "Sorter etter verdiene i det første beregnede feltet",
  "AlphaAscending": "Verdi stigende",
  "AlphaDescending": "Verdi synkende",
  "ChiSquare": "Chi-kvadrat",
  "Nosort": "Ingen sortering",
  "NosortDescription": "Ikke sorter verdiene. Verdiene vil komme tilbake i en tilfeldig rekkefølge.",
  "RelativeFrequency": "Relativ frekvens",
  "RelativeFrequencyDescription": "Sorter basert på den relative frekvensen av verdier. Mindre vanlige verdier vil vises høyere.",
  "DateDistribution": "Datodistribusjon",
  "Custom": "Tilpasset",
  "CustomDescription": "Sorter basert på en tilpasset rekkefølge",
  "ComputedField": "Beregnet felt",
  "Ascending": "Stigende",
  "Descending": "Synkende",
  "noResultFor": "Ingen resultater for {0}",
  "autoCorrectedQueryTo": "Forespørsel ble automatisk korrigert til {0}",
  "didYouMean": "Mente du: {0}",
  "SuggestedResults": "Foreslåtte resultater",
  "SuggestedQueries": "Foreslåtte forespørsler",
  "MostRelevantItems": "Mest relevante elementer:",
  "AllItems": "Alle elementer:",
  "ShowLess": "Vis mindre",
  "ShowMore": "Vis mer",
  "HideFacet": "Skjul fasett",
  "ShowFacet": "Vis fasett",
  "AndOthers": "og {0} <sn>annen</sn><pl>andre</pl>",
  "Others": "{0} <sn>annen</sn><pl>andre</pl>",
  "MostRelevantPosts": "Mest relevante poster",
  "CompleteThread": "Fullstendig tråd:",
  "ShowCompleteThread": "Vis fullstendig tråd",
  "ShowOnlyTopMatchingPosts": "Vis kun de postene som matcher best",
  "MostRelevantReplies": "Mest relevante svar",
  "AllConversation": "All konversasjon:",
  "ShowAllConversation": "Vis all konversasjon",
  "ShowAllReplies": "Vis alle svar",
  "ShowOnlyMostRelevantReplies": "Vis kun de mest relevante svarene",
  "Close": "Lukk",
  "Open": "Åpne",
  "OpenInOutlookWhenPossible": "Åpne i Outlook (hvor mulig)",
  "AlwaysOpenInNewWindow": "Åpne alltid resultater i nytt vindu",
  "Quickview": "Hurtigvisning",
  "NoQuickview": "Hurtigvisning for dette dokumentet er ikke tilgjengelig",
  "ErrorReport": "Feilrapport",
  "OopsError": "Noe gikk galt på serveren.",
  "ProblemPersists": "Kontakt administratoren hvis problemet vedvarer.",
  "GoBack": "Gå tilbake",
  "Reset": "Tilbakestill",
  "Retry": "Prøv på nytt",
  "MoreInfo": "Mer informasjon",
  "Username": "Brukernavn",
  "Password": "Passord",
  "PostedBy": "Postet av",
  "CannotConnect": "Kan ikke koble til serveradressen.",
  "BadUserPass": "Passord samsvarer ikke med brukernavnet.",
  "PleaseEnterYourCredentials": "Vennligst angi dine akkreditiver for {0}.",
  "PleaseEnterYourSearchPage": "Vennligst angi URL for din søkeside",
  "Collapse": "Fold sammen",
  "Collapsable": "Sammenfoldbar",
  "Expand": "Utvid",
  "Today": "I dag",
  "Yesterday": "I går",
  "Tomorrow": "I morgen",
  "Duration": "Varighet: {0}",
  "IndexDuration": "Indeks varighet: {0}",
  "ProxyDuration": "Proxy varighet: {0}",
  "ClientDuration": "Klient varighet: {0}",
  "Unavailable": "Utilgjengelig",
  "Reply": "Svar",
  "ReplyAll": "Svar alle",
  "Forward": "Videresend",
  "From": "Fra",
  "Caption": "Tittel",
  "Expression": "Uttrykk",
  "Tab": "Fane",
  "Tabs": "Faner",
  "EnterExpressionName": "Angi uttrykksnavn",
  "EnterExpressionToFilterWith": "Angi uttrykk å filtrere resultater med",
  "SelectTab": "Velg fane",
  "SelectAll": "Velg alle",
  "PageUrl": "Velg URL for side",
  "ErrorSavingToDevice": "Feil ved lagring av informasjon til din enhet",
  "ErrorReadingFromDevice": "Feil ved lesing av informasjon fra din enhet",
  "AppIntro": "Snakk med en produktspesialist som kan besvare dine spørsmål om Coveo og hjelpe deg å avgjøre hvilken Coveo-løsning som er riktig for deg. Eller prøv en live demo!",
  "TryDemo": "Prøv demoen",
  "ContactUs": "Kontakt oss",
  "NewToCoveo": "Ny med Coveo?",
  "LetUsHelpGetStarted": "La oss hjelpe deg å komme i gang",
  "LikesThis": "{0} liker dette.",
  "CannotConnectSearchPage": "kan ikke koble til din søkeside",
  "AreYouSureDeleteFilter": "Er du sikker på at du ønsker å slette filter {0} med uttrykket {1}",
  "OnlineHelp": "Online hjelp",
  "Done": "Ferdig",
  "SaveFacetState": "Lagre denne fasettstatusen",
  "ClearFacetState": "Tøm fasettstatus",
  "DisplayingTheOnlyMessage": "Viser den eneste meldingen i denne samtalen",
  "NoNetworkConnection": "Ingen nettverksforbindelse",
  "UnknownConnection": "Ukjent tilkobling",
  "EthernetConnection": "Ethernet-tilkobling",
  "WiFi": "WiFi-tilkobling",
  "CELL": "Mobil tilkobling",
  "CELL_2G": "Mobil 2G-tilkobling",
  "CELL_3G": "Mobil 3G-tilkobling",
  "CELL_4G": "Mobil 4G-tilkobling",
  "Relevance": "Relevans",
  "Date": "Dato",
  "Amount": "Mengde",
  "QueryExceptionNoException": "Ingen unntak",
  "QueryExceptionInvalidSyntax": "Ugyldig syntaks",
  "QueryExceptionInvalidCustomField": "Ugyldig tilpasset felt",
  "QueryExceptionInvalidDate": "Ugyldig dato",
  "QueryExceptionInvalidExactPhrase": "Ugyldig nøyaktig frase",
  "QueryExceptionInvalidDateOp": "Ugyldig datooperatør",
  "QueryExceptionInvalidNear": "Ugyldig NEAR-operatør",
  "QueryExceptionInvalidWeightedNear": "Ugyldig vektet NEAR",
  "QueryExceptionInvalidTerm": "Ugyldig term",
  "QueryExceptionTooManyTerms": "For mange termer",
  "QueryExceptionWildcardTooGeneral": "Jokertegn for generelt",
  "QueryExceptionInvalidSortField": "Ugyldig sorteringsfelt",
  "QueryExceptionInvalidSmallStringOp": "Ugyldig liten stringoperatør",
  "QueryExceptionRequestedResultsMax": "Forespurte resultater maksimum",
  "QueryExceptionAggregatedMirrorDead": "Fjern indekskopi offline",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Fjern indekskopi forespørsel timeout",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Fjern indekskopi ugyldig byggnummer",
  "QueryExceptionAggregatedMirrorCannotConnect": "Fjern indekskopi kan ikke koble til",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Ikke nok ledende tegn i jokertegn",
  "QueryExceptionSecurityInverterNotFound": "Sikkerhetsinverter ikke funnet",
  "QueryExceptionSecurityInverterAccessDenied": "Adgang til sikkerhetsinverter avslått",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Fjern indekskopi kan ikke representere",
  "QueryExceptionUnexpected": "Uventet",
  "QueryExceptionAccessDenied": "Adgang avslått",
  "QueryExceptionSuperUserTokenInvalid": "Superbruker symbol ikke gyldig",
  "QueryExceptionSuperUserTokenExpired": "Superbruker symbol er utløpt",
  "QueryExceptionLicenseQueriesExpired": "Forespørselslisens utløpt",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Lisens for superbruker symbol ikke støttet",
  "QueryExceptionInvalidSession": "Ugyldig økt",
  "QueryExceptionInvalidDocument": "Ugyldig dokument",
  "QueryExceptionSearchDisabled": "Søk deaktivert",
  "FileType": "Filtype",
  "ShowAttachment": "Vis vedlegg",
  "OnFeed": "på {0}s feed.",
  "Author": "Forfatter",
  "NoTitle": "Ingen tittel",
  "CurrentSelections": "Gjeldende valg",
  "AllContent": "Alt innhold",
  "CancelLastAction": "Avbryt siste handling",
  "SearchTips": "Søketips",
  "CheckSpelling": "Sjekk staving for dine nøkkelord",
  "TryUsingFewerKeywords": "Prøv å bruke færre, andre eller flere generelle nøkkelord.",
  "SelectFewerFilters": "Velg færre filtre for å utvide søket ditt",
  "Document": "Dokument",
  "Time": "Tid",
  "StartDate": "Startdato",
  "StartTime": "Starttid",
  "DurationTitle": "Varighet",
  "UserQuery": "Brukerforespørsel",
  "ShowUserActions": "Vis brukerhandlinger",
  "NoData": "Ingen data tilgjengelig",
  "EventType": "Hendelsetype",
  "GoToFullSearch": "Fult søk",
  "GoToEdition": "Tilpass panel",
  "RemoveContext": "Fjern kontekst",
  "BoxAttachToCase": "Legg ved sak",
  "AttachToCase": "Legg ved sak",
  "Attach": "Legg ved",
  "Attached": "Vedlagt",
  "Detach": "Løsne",
  "Details": "Detaljer",
  "AdditionalFilters": "Ytterligere filtre",
  "SelectNonContextualSearch": "Fjern kontekst fra den gjeldende registreringen for å utvide søket ditt",
  "CopyPasteToSupport": "Kopier og lim inn denne meldingen til Coveo Brukerstøtte for mer informasjon.",
  "FollowQueryDescription": "Send meg varsel om endringer i søkeresultatet for dette søket.",
  "SearchAlerts_Panel": "Administrer varsler",
  "SearchAlerts_PanelDescription": "Se og administrer dine søk-varsler.",
  "SearchAlerts_PanelNoSearchAlerts": "Du har ingen abonnementer.",
  "SearchAlerts_Fail": "Søk-varsel-tjenesten er for tiden ikke tilgjengelig.",
  "SearchAlerts_Type": "Type",
  "SearchAlerts_Content": "Innhold",
  "SearchAlerts_Actions": "Handling",
  "EmptyQuery": "<tom>",
  "SearchAlerts_Type_followQuery": "Forespørsel",
  "SearchAlerts_Type_followDocument": "Enhet",
  "SearchAlerts_unFollowing": "Slutt å følge",
  "SearchAlerts_follow": "Følg",
  "SearchAlerts_followed": "Fulgt",
  "SearchAlerts_followQuery": "Følg forespørsel",
  "Subscription_StopFollowingQuery": "Slutt å følge forespørsel",
  "SearchAlerts_Frequency": "Når",
  "SubscriptionsManageSubscriptions": "Administrer varsler",
  "SubscriptionsMessageFollowQuery": "Du vil motta varsler når forespørselen <b>{0}</b> kommer tilbake med nye eller oppdaterte enheter.",
  "SubscriptionsMessageFollow": "Du vil motta varsler om endringer for enheten <b>{0}</b>.",
  "Expiration": "Utløpsdato",
  "Monthly": "Månedlig",
  "Daily": "Daglig",
  "Monday": "Mandag",
  "Tuesday": "Tirsdag",
  "Wednesday": "Onsdag",
  "Thursday": "Torsdag",
  "Friday": "Fredag",
  "Saturday": "Lørdag",
  "Sunday": "Søndag",
  "NextDay": "Neste {0}",
  "LastDay": "Siste {0}",
  "StartTypingCaseForSuggestions": "Beskriv problemet ditt for å se mulige løsninger",
  "ExportToExcel": "Eksporter til Excel",
  "ExportToExcelDescription": "Eksporter søkeresultatene til Excel",
  "CaseCreationNoResults": "Ingen anbefalte løsninger ble funnet",
  "SortBy": "Sorter etter",
  "BoxCreateArticle": "Opprett artikkel",
  "Facets": "Fasetter",
  "AdvancedSearch": "Avansert søk",
  "Keywords": "Nøkkelord",
  "AllTheseWords": "Alle disse ordene",
  "ExactPhrase": "Denne eksakte frasen",
  "AnyOfTheseWords": "Ett av disse ordene",
  "NoneOfTheseWords": "Ingen av disse ordene",
  "Anytime": "Når som helst",
  "InTheLast": "I det minste",
  "Days": "dager",
  "Months": "måneder",
  "Month": "Måned",
  "Year": "År",
  "Between": "Mellom",
  "Language": "Språk",
  "Size": "Størrelse",
  "AtLeast": "minimum",
  "AtMost": "maksimum",
  "Contains": "inneholder",
  "DoesNotContain": "inneholder ikke",
  "Matches": "stemmer med",
  "Bytes": "byte",
  "card": "Kort",
  "table": "Tabell",
  "ResultLinks": "Resultat-lenker",
  "EnableQuerySyntax": "Aktiver søk-syntaks",
  "On": "På",
  "Off": "Av",
  "Automatic": "Automatisk",
  "ResultsPerPage": "Resultater per side",
  "PreviousMonth": "Forrige måned",
  "NextMonth": "Neste måned",
  "Title": "Tittel",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["no"] = merge(locales["no"], dict);
  String["toLocaleString"].call(this, { "no": dict });
  String["locale"] = "no";
  String["defaultLocale"] = "en";
  Globalize.culture("no")
}